/*
 * Decompiled with CFR 0.152.
 */
package net.nooj4nlp.gui.dialogs.OpenCorpusDialog;

import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.BevelBorder;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableRowSorter;
import net.miginfocom.swing.MigLayout;
import net.nooj4nlp.controller.TextEditorShell.TextEditorShellController;
import net.nooj4nlp.engine.Charlist;
import net.nooj4nlp.engine.Language;
import net.nooj4nlp.engine.helper.BackgroundWorker;
import net.nooj4nlp.gui.main.Launcher;

public class AlphabetDialog
extends JInternalFrame
implements PropertyChangeListener {
    private static final long serialVersionUID = 178125551413285417L;
    private JLabel label;
    private JTable tableChars;
    private TextEditorShellController textController;

    public AlphabetDialog(TextEditorShellController textController) {
        this.textController = textController;
        this.setTitle("Characters in " + (textController.getTextName() == null ? "" : textController.getTextName()));
        this.setBounds(120, 120, 248, 373);
        this.setIconifiable(true);
        this.setMaximizable(true);
        this.setResizable(true);
        this.setClosable(true);
        this.getContentPane().setLayout((LayoutManager)new MigLayout("", "[232px]", "[20!, grow][grow]"));
        this.label = new JLabel("New label");
        this.getContentPane().add((Component)this.label, "cell 0 0,alignx left,aligny top");
        DefaultTableModel tableModel = new DefaultTableModel(new Object[]{"Freq", "Char", "Type", "Unicode"}, 0);
        this.tableChars = new JTable(tableModel);
        JScrollPane scrollPane1 = new JScrollPane(this.tableChars);
        scrollPane1.setBorder(new BevelBorder(1, null, null, null, null));
        this.getContentPane().add((Component)scrollPane1, "cell 0 1,grow");
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("progress" == evt.getPropertyName()) {
            int progress = (Integer)evt.getNewValue();
            Launcher.getStatusBar().getProgressBar().setIndeterminate(false);
            Launcher.getStatusBar().getProgressBar().setValue(progress);
        }
    }

    public void fillInTheAlphabet(Charlist charlist) {
        if (charlist == null) {
            this.tableChars.setModel(new DefaultTableModel(new Object[]{"Freq", "Char", "Type", "Unicode"}, 0));
            return;
        }
        ArrayList<Character> chars = charlist.getChars();
        ArrayList<Integer> freqs = charlist.getFreqs();
        this.tableChars.setModel(new DefaultTableModel(new Object[]{"Freq", "Char", "Type", "Unicode"}, 0));
        DefaultTableModel tableCharsModel = (DefaultTableModel)this.tableChars.getModel();
        for (int i = 0; i < chars.size(); ++i) {
            char c = chars.get(i).charValue();
            int f = freqs.get(i);
            char code = c;
            String scode = String.format("%04X", code);
            String t = Language.isLetter(c) ? "Let" : (Character.isDigit(c) ? "Dig" : (Character.isWhitespace(c) ? "Blk" : "Del"));
            Object[] row = new Object[]{f, Character.valueOf(c), t, scode};
            tableCharsModel.addRow(row);
        }
        TableRowSorter<DefaultTableModel> sorter = new TableRowSorter<DefaultTableModel>(tableCharsModel);
        sorter.setComparator(0, new Comparator<Integer>(){

            @Override
            public int compare(Integer o1, Integer o2) {
                if (o1 < o2) {
                    return -1;
                }
                if (o1 > o2) {
                    return 1;
                }
                return 0;
            }
        });
        this.tableChars.setRowSorter(sorter);
        this.label.setText("Text has " + chars.size() + " characters.");
    }

    public void fillInTheData(boolean isACorpus) {
        this.alphabetisation(this.textController);
    }

    private void alphabetisation(TextEditorShellController textController) {
        if (Launcher.backgroundWorking) {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "One process is already running.", "NooJ: one process only in this version", 0);
            return;
        }
        Launcher.initialDate = new Date();
        if (this.isVisible()) {
            this.hide();
        }
        textController.desactivateOps();
        Launcher.getStatusBar().getBtnCancel().setEnabled(true);
        Launcher.getStatusBar().getBtnCancel().setForeground(Color.red);
        Launcher.getStatusBar().getProgressLabel().setText("Alphabetisation...");
        Launcher.backgroundWorking = true;
        Launcher.backgroundWorker = new BackgroundWorker("text alphabetisation", textController, null);
        Launcher.backgroundWorker.addPropertyChangeListener(this);
        Launcher.backgroundWorker.execute();
        textController.computeAlphabet();
        this.fillInTheAlphabet(textController.getMyText().charlist);
        textController.reactivateOps();
        textController.updateTextPaneStats();
        textController.rtbTextUpdate(false);
        this.show();
        Date now = new Date();
        long sec = (now.getTime() - Launcher.initialDate.getTime()) / 1000L;
        Launcher.getStatusBar().getProgressLabel().setText(Long.toString(sec) + " sec");
    }

    public TextEditorShellController getTextController() {
        return this.textController;
    }
}

